//------------------------------------------------------------------------------
// File: Famine.cs
// Controls the famine scenario tasks
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$Famine::QuestName    = "A Well-Planned Plot";
$Famine::FirstTask    = "Match the right crate with the right Well.";
$Famine::Hint1        = "Each crate will only decontaminate one Well."; 
$Famine::Hint2        = "None of the crates decontaminate the Well they're near.";    
$Famine::Hint3        = "The crate near the Well that is full of garbage is the cure for the Well that smells of bad eggs.";   
$Famine::Hint4        = "The crate near the salty Well is defiantly not the cure for the Well with iron in it.";   
$Famine::Box1location = "This crate was found near the sulfur Well.";
$Famine::Box2location = "This crate was found near the Well with iron in it.";
$Famine::Box3location = "This crate was found near the salty Well.";
$Famine::Box4location = "This crate was found near the Well with garbage in it.";
$Famine::FoodLoss     = 15;

$Famine::HashVal[0]   = slgHashString("id_famine_wellbox1well1");
$Famine::HashVal[1]   = slgHashString("id_famine_wellbox1well2");
$Famine::HashVal[2]   = slgHashString("id_famine_wellbox1well3");
$Famine::HashVal[3]   = slgHashString("id_famine_wellbox1well4");
$Famine::HashVal[4]   = slgHashString("id_famine_wellbox2well1");
$Famine::HashVal[5]   = slgHashString("id_famine_wellbox2well2");
$Famine::HashVal[6]   = slgHashString("id_famine_wellbox2well3");
$Famine::HashVal[7]   = slgHashString("id_famine_wellbox2well4");
$Famine::HashVal[8]   = slgHashString("id_famine_wellbox3well1");
$Famine::HashVal[9]   = slgHashString("id_famine_wellbox3well2");
$Famine::HashVal[10]  = slgHashString("id_famine_wellbox3well3");
$Famine::HashVal[11]  = slgHashString("id_famine_wellbox3well4");
$Famine::HashVal[12]  = slgHashString("id_famine_wellbox4well1");
$Famine::HashVal[13]  = slgHashString("id_famine_wellbox4well2");
$Famine::HashVal[14]  = slgHashString("id_famine_wellbox4well3");
$Famine::HashVal[15]  = slgHashString("id_famine_wellbox4well4");
$Famine::HashValCount = 16;


   
/******************************************************************************/
/** FAMINE HELPERS
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
//! Activates the famine tasks
////////////////////////////////////////////////////////////////////////////////
function startFamineTasks()
{
   tsStartTask("FamineTask", tsGetStartingVertexes("FamineTask"));
   tsStartTask("FaminePuzzle", "FaminePuzzleStart");
}
////////////////////////////////////////////////////////////////////////////////
//! Deactivates famine tasks
////////////////////////////////////////////////////////////////////////////////
function endFamineTasks()
{
   tsEndTask("FaminePuzzle");
   tsEndTask("FamineTask");
}
////////////////////////////////////////////////////////////////////////////////
//! Called when the famine scenario has been won
////////////////////////////////////////////////////////////////////////////////
function winFamineTasks()
{ 
   //Reward
   tsModifyResource($Resource::Experience, 20, true);
   tsModifyResource($Resource::Gold, 100, true);
   tsModifyResource($Resource::Wood, 100, true);
   SendProductionToClient(HeroCharacter, "20 experience");
   SendProductionToClient(HeroCharacter, "100 gold");
   SendProductionToClient(HeroCharacter, "100 wood");
   
   faminechar.deleteobject();
}
////////////////////////////////////////////////////////////////////////////////
//! Sends click dialogs to the hero character when entering a well zone
//! \param %well Well internal name
////////////////////////////////////////////////////////////////////////////////
function sendFamineBoxUseDlg(%well)
{
    // Spawn dialog for boxes obtained
   if(FaminePuzzleBoxOne.hasBeenCompleted()) {
      %id = "id_famine_wellbox1" @ %well;
      tsSendTaskClickDlg("id_famine_wellbox1name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
   if(FaminePuzzleBoxTwo.hasBeenCompleted()) {
      %id = "id_famine_wellbox2" @ %well;
      tsSendTaskClickDlg("id_famine_wellbox2name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
   if(FaminePuzzleBoxThree.hasBeenCompleted()) {
      %id = "id_famine_wellbox3" @ %well;
      tsSendTaskClickDlg("id_famine_wellbox3name", %id, $TaskButton::Accept, "HeroCharacter", %id);
   }
   if(FaminePuzzleBoxFour.hasBeenCompleted()) {
      %id = "id_famine_wellbox4" @ %well;
      tsSendTaskClickDlg("id_famine_wellbox4name", %id, $TaskButton::Accept, "HeroCharacter", %id);
   }
}


/******************************************************************************/
/** FAMINE HINT DIALOGS
/******************************************************************************/
//-FamineIntro Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This is responsible for displaying initial dialog upon entering the
// introductory zone
////////////////////////////////////////////////////////////////////////////////
function FamineIntro::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_intro", $TaskButton::Okay, "farmer1");
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_introtwo", $TaskButton::Okay, "farmer1", "id_famine_intro");
   
   // Quest log
   tsAddQuestToTracker(true, $Famine::QuestName, "", "Figure out which crate decontaminates the water in each Well so the Copperheads can't run the townsfolk off.", "Reward: 20 experience, 100 gold, 100 wood");
   tsReadyQuest($Famine::QuestName);
   tsAddTaskToTracker($Famine::QuestName, "Decontaminate all of the Wells.", "All of the Wells have been contaminated. Find the right fix for each Well.");
   
   %Farmername = farmer1.name;
   $Famine::QuestHint1 = %Farmername@" Hint!";
   tsAddQuestToTracker(false, $Famine::QuestHint1, $Famine::Hint1, "", "");
   tsReadyQuest($Famine::QuestHint1);

   //tsAddTaskToTracker($Famine::QuestHint1, "", "Each crate will fix the problem with one Well. Match the right crate with the right Well.");
}
//-WellOneName Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for well one name
////////////////////////////////////////////////////////////////////////////////
function WellOneName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_wellone", $TaskButton::Okay, "well1");
}
//-WellTwoName Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for well two name
////////////////////////////////////////////////////////////////////////////////
function WellTwoName::onExit(%this)
{
   Parent::onExit(%this);

   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_well2", $TaskButton::Okay, "well2");
}
//-WellThreeName Vertex---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for well three name
////////////////////////////////////////////////////////////////////////////////
function WellThreeName::onExit(%this)
{
   Parent::onExit(%this);

   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_well3", $TaskButton::Okay, "well3");
}
//-WellFourName Vertex----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for well four name
////////////////////////////////////////////////////////////////////////////////
function WellFourName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_well4", $TaskButton::Okay, "well4");
}
//-BoxOneName Vertex------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for box one name
////////////////////////////////////////////////////////////////////////////////
function BoxOneName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_wellbox1", $TaskButton::Okay, "wellbox1");
   
   //Quest log
   %boxname = wellbox1.name;
   tsAddQuestToTracker(false, %boxname, $Famine::Box1location, "", "");
   tsReadyQuest(%boxname);
}
//-BoxTwoName Vertex------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for box two name
////////////////////////////////////////////////////////////////////////////////
function BoxTwoName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_wellbox2", $TaskButton::Okay, "wellbox2");
   //Quest log
   %boxname = wellbox2.name;
   tsAddQuestToTracker(false, %boxname, $Famine::Box2location, "", "");
   tsReadyQuest(%boxname);
}
//-BoxThreeName Vertex----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for box three name
////////////////////////////////////////////////////////////////////////////////
function BoxThreeName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_wellbox3", $TaskButton::Okay, "wellbox3");
   //Quest log
   %boxname = wellbox3.name;
   tsAddQuestToTracker(false, %boxname, $Famine::Box3location, "", "");
   tsReadyQuest(%boxname);
}
//-BoxFourName Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops-up dialog for box four name
////////////////////////////////////////////////////////////////////////////////
function BoxFourName::onExit(%this)
{
   Parent::onExit(%this);
   
   // Dialog about object
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_wellbox4", $TaskButton::Okay, "wellbox4");
   //Quest log
   %boxname = wellbox4.name;
   tsAddQuestToTracker(false, %boxname, $Famine::Box4location, "", "");
   tsReadyQuest(%boxname);
}



/******************************************************************************/
/** FAMINE PUZZLE VERTEXES
/******************************************************************************/
//-FamineSpawnSolutions Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns the well boxes
////////////////////////////////////////////////////////////////////////////////
function FamineSpawnSolutions::onEnter(%this)
{
   Parent::onEnter(%this);
      
   // Spawn boxes
   %obj = tsCreateObj("cratepickup", "Crate of Baking Soda", "", "-293 -321", "wellbox1");
   %obj.setName("wellbox1");
   %obj = tsCreateObj("cratepickup", "Crate of Dried Pine Sap", "", "-282 -394", "wellbox2");
   %obj.setName("wellbox2");
   %obj = tsCreateObj("cratepickup", "Crate of Netting", "", "-400 -385", "wellbox3");
   %obj.setName("wellbox3");
   %obj = tsCreateObj("cratepickup", "Crate of Mysterious Black Gravel", "", "-394 -258", "wellbox4");
   %obj.setName("wellbox4");
   
   tsCompleteVertexes("FaminePuzzle", "FamineSpawnSolutions");  
}

function FamineHint2::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_FAMINE", "id_famine_hinttwo", $TaskButton::Okay, "farmer2", "id_famine_hinttwo");
}
function FamineHint2Questlog::onExit(%this)
{
   //Quest log
   %Farmername = farmer2.name;
   %Famine::QuestHint = %Farmername@" Hint!";
   tsAddQuestToTracker(false, %Famine::QuestHint, $Famine::Hint2, "", "");
   tsReadyQuest(%Famine::QuestHint);
}
function FamineHint3::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_FAMINE", "id_famine_hintthree", $TaskButton::Okay, "farmer3", "id_famine_hintthree");
}
function FamineHint3Questlog::onExit(%this)
{
   //Quest log
   %Farmername = farmer3.name;
   %Famine::QuestHint = %Farmername@" Hint!";
   tsAddQuestToTracker(false, %Famine::QuestHint, $Famine::Hint3, "", "");
   tsReadyQuest(%Famine::QuestHint);
}
function FamineHint4::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_FAMINE", "id_famine_hintfour", $TaskButton::Okay, "farmer4", "id_famine_hintfour");
}
function FamineHint4Questlog::onExit(%this)
{
   //Quest log
   %Farmername = farmer4.name;
   %Famine::QuestHint = %Farmername@" Hint!";
   tsAddQuestToTracker(false, %Famine::QuestHint, $Famine::Hint4, "", "");
   tsReadyQuest(%Famine::QuestHint);
}
//-FaminePuzzleBoxOne Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the first puzzle box is picked up. If a character is in a well
// zone, a task dialog is sent for this box
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleBoxOne::onExit(%this)
{
   Parent::onExit(%this);
   
   // Display click dialog if in zone
   if(FaminePuzzleWellOne.hasBeenCompleted()) {
      %id = "id_famine_wellbox1well1";
      tsSendTaskClickDlg("id_famine_wellbox1name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
}
//-FaminePuzzleBoxTwo Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the second puzzle box is picked up. If a character is in a 
// well zone, a task dialog is sent for this box
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleBoxTwo::onExit(%this)
{
   Parent::onExit(%this);
   
   // Display click dialog if in zone
   if(FaminePuzzleWellTwo.hasBeenCompleted()) {
      %id = "id_famine_wellbox2well2";
      tsSendTaskClickDlg("id_famine_wellbox2name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
}
//-FaminePuzzleBoxThree Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the third puzzle box is picked up. If a character is in a well
// zone, a task dialog is sent for this box
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleBoxThree::onExit(%this)
{
   Parent::onExit(%this);
   
   // Display click dialog if in zone
   if(FaminePuzzleWellThree.hasBeenCompleted()) {
      %id = "id_famine_wellbox3well3";
      tsSendTaskClickDlg("id_famine_wellbox3name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
}
//-FaminePuzzleBoxFour Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the fourth puzzle box is picked up. If a character is in a 
// well zone, a task dialog is sent for this box
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleBoxFour::onExit(%this)
{
   Parent::onExit(%this);
   
   // Display click dialog if in zone
   if(FaminePuzzleWellFour.hasBeenCompleted()) {
      %id = "id_famine_wellbox4well4";
      tsSendTaskClickDlg("id_famine_wellbox4name", %id, $TaskButton::Accept, "HeroCharacter", %id); 
   }
}
//-FaminePuzzleWellOne Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the character enters the first well zone. Sends a task
// dialog for any puzzle box vertexes completed
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleWellOne::onExit(%this)
{
   Parent::onExit(%this);
   sendFamineBoxUseDlg("well1");
   TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleNoWell");
   tsActivateVertexes("FaminePuzzle", "FaminePuzzleNoWell");
}
//-FaminePuzzleWellTwo Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the character enters the second well zone. Sends a task
// dialog for any puzzle box vertexes completed
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleWellTwo::onExit(%this)
{
   Parent::onExit(%this);
   sendFamineBoxUseDlg("well2");
   TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleNoWell");
   tsActivateVertexes("FaminePuzzle", "FaminePuzzleNoWell");
}
//-FaminePuzzleWellThree Vertex-------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the character enters the third well zone. Sends a task
// dialog for any puzzle box vertexes completed
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleWellThree::onExit(%this)
{
   Parent::onExit(%this);
   sendFamineBoxUseDlg("well3");
   TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleNoWell");
   tsActivateVertexes("FaminePuzzle", "FaminePuzzleNoWell");
}
//-FaminePuzzleWellFour Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the character enters the fourth well zone. Sends a task
// dialog for any puzzle box vertexes completed
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleWellFour::onExit(%this)
{
   Parent::onExit(%this);
   sendFamineBoxUseDlg("well4");
   TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleNoWell");
   tsActivateVertexes("FaminePuzzle", "FaminePuzzleNoWell");
}
//-FaminePuzzleNoWell Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Completes when the character enters the outerwellzone. Responsible for 
// removing any task dialog on the character and resetting the other zone 
// vertexes
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleNoWell::onExit(%this)
{
   Parent::onExit(%this);
   
   if(FaminePuzzleWellOne.hasBeenCompleted()) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellOne");
      TaskModifier.strMarkVertex("FaminePuzzle", "FaminePuzzleWellOne", $TSV_AVAIL);
   }
   if(FaminePuzzleWellTwo.hasBeenCompleted()) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellTwo");
      TaskModifier.strMarkVertex("FaminePuzzle", "FaminePuzzleWellTwo", $TSV_AVAIL);
   }
   if(FaminePuzzleWellThree.hasBeenCompleted()) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellThree");
      TaskModifier.strMarkVertex("FaminePuzzle", "FaminePuzzleWellThree", $TSV_AVAIL);
   }
   if(FaminePuzzleWellFour.hasBeenCompleted()) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellFour");
      TaskModifier.strMarkVertex("FaminePuzzle", "FaminePuzzleWellFour", $TSV_AVAIL);
   }
   
   tsDestroyAllTaskDlg("HeroCharacter", true);
}
//-FaminePuzzleWin--------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex becomes available if the player correctly chooses the four boxes
// for the four wells
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleWin::onEnter(%this)
{
   tsCompleteTaskInTracker($Famine::QuestName, $Famine::FirstTask);
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_win", $TaskButton::More, "farmer1");
   tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_returntomain", $TaskButton::Okay, "HeroCharacter", "id_famine_returntomain");
}
function FaminePuzzleWin::onExit(%this)
{
   %scenario = new SLScenario() {
      stack = false;
   };
   LoadScenario(%scenario, endFamineTasks, winFamineTasks);
   
   // complete the famine satellite
   mapsatellite_famine.disabled = false;
}
function resetFamineTasks()
{
   TaskModifier.strMarkVertex("GeneralTasks", "MainmapFamineResetDelay", $TSV_AVAIL);
}
//-FaminePuzzleLose-------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex becomes available after
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleLose::onUpdate(%this)
{
   // We've lost if this is the case
   if(FaminePuzzleWin.isUnavailable()) {
      // Change resources
      tsModifyResource($Resource::Food, $Famine::FoodLoss, false);
      
      // Kill hint dialogs (will be regenerated)
      tsDestroyAllTaskDlg("farmer2", true);
      tsDestroyAllTaskDlg("farmer3", true);
      tsDestroyAllTaskDlg("farmer4", true);
   
      tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_lose", $TaskButton::Okay, "farmer1");
      %food = rsGetResourceCount($Resource::Food);
      if(%food > 0) {
         tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_tryagain", $TaskButton::Okay, "farmer1");
         TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleOnDialog");
         TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleOnWellOneSolution");
         TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleOnWellTwoSolution");
         TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleOnWellThreeSolution");
         TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleOnWellFourSolution");
         tsActivateVertexes("FaminePuzzle", "FaminePuzzleStart");
      }
      else {
         tsSendTaskPopUpDlg("ID_TASKNAME_FAMINE", "id_famine_restart", $TaskButton::Okay, "farmer1", "id_famine_restart");
         tsCompleteVertexes("FaminePuzzle", "FaminePuzzleLose");
      }
   }
}
//-FaminePuzzleRestart----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Restarts the scenario on lose
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleRestart::onExit(%this)
{
   tsRestartScenario();
}
//-FaminePuzzleTryAgain---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Resets the puzzle if you fail but still have enough food resources to try
// again
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleTryAgain::onExit(%this)
{
   tsCompleteVertexes("FaminePuzzle", "FaminePuzzleStart");
}

//-FaminePuzzleOnDialog---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Used to monitor how many dialogs have been processed at the various wells.
// Once four dialogs go through this method, then the win/lose condition must
// be evaluated
////////////////////////////////////////////////////////////////////////////////
function FaminePuzzleOnDialog::onMessage(%this, %msg, %params)
{
   %dlgId = getWord(%params, 1);
   
   // Not one of these break out
   for(%i = 0; %i < $Famine::HashValCount; %i++) {
      if(%dlgId $= $Famine::HashVal[%i]) {
         break;
      }
   }
   if(%i >= $Famine::HashValCount) {
      return;
   }
   
   Parent::onMessage(%this, %msg, %params);
   
   // Mark off well zone we placed box in AND box we used
   if(%i < 4) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleBoxOne");
      %i++;
   }
   else if(%i < 8) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleBoxTwo");
      %i = %i - 3;
   }
   else if(%i < 12) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleBoxThree");
      %i = %i - 7;
   }
   else {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleBoxFour");
      %i = %i - 11;
   }
   if(%i == 1) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellOne");
   }
   else if(%i == 2) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellTwo");
   }
   else if(%i == 3) {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellThree");
   }
   else {
      TaskModifier.strResetVertex("FaminePuzzle", "FaminePuzzleWellFour");
   }
   
   // Destroy dialog on character
   tsDestroyAllTaskDlg("HeroCharacter", true);
}
// End Famine.cs